/*jslint node: true, nomen: true, unparam: true */
/*global jquery, _, $, define, navigator, window */

'use strict';
define([ 'jquery' ], function ($) {
    return (function () {
        var _selectMenu = {};

        _selectMenu.calculateHeight = function calculate(modalDialog) {
            var page = modalDialog || $('.ui-page-active.ui-dialog');
            var populatedZones =
                page.find(".ui-dialog-contain > .ui-header").outerHeight() +
                page.find(".ui-dialog-contain > .ui-footer").outerHeight() +
                30 + 2;// .ui-content's top bottom padding and extra so user sees they are at the bottom

                return ('height:' + ($(window).innerHeight() - populatedZones) + 'px');
        };

        _selectMenu.register = function register() {
            var that = this;

            $(window).resize(function () {
                $('.ui-page-active .scrollable-modal').attr('style', that.calculateHeight());
            });

            // Custom "selectmenu" without going through Backbone router
            $(document).on('keydown tap', '.ui-select > a', function(e) {
                var $anchor = $(e.currentTarget),
                    menuContainer = $anchor.attr('href'),
                    rel = $anchor.attr('data-rel'); // jqmData('rel') updated afters

                if (e.type ==='keydown' && e.which !== 13) { return; }

                e.preventDefault();

                if (rel === "popup") {
                    $(menuContainer).popup('open', {
                        positionTo: $anchor.jqmData('positionTo') || $anchor.attr('data-position-to') || $anchor,
                        transition: $anchor.jqmData('transition') || $anchor.attr('data-transition') || "none"
                    });
                } else if ( rel === "dialog" ) {
                    /* need elements in DOM to calculate height */
                    $(menuContainer).on('pageshow', function(e) {
                        $(menuContainer).find(".ui-content").addClass("scrollable-modal");
                        $('.scrollable-modal').attr('style', that.calculateHeight( $(menuContainer) ));
                    });

                    /* on close via [x] */
                    $(menuContainer).on('keydown tap', 'a[title="Close"]', function(e) {

                        if (e.type ==='keydown' && e.which !== 13) { return; }

                        e.preventDefault();
                        that.closeSelectMenuDialog();
                    });

                    $(menuContainer).on('pagehide', function(e) {
                        $(document).off('keydown tap', menuContainer + ' a[title="Close"]');
                        // TODO: auto destroy to play nice with Backbone    
                        //$(menuContainer).dialog('destroy');
                        //$(menuContainer).remove();
                    });

                    $.mobile.changePage( menuContainer, { role: "dialog" } );
                }
            });
        };

        _selectMenu.closeSelectMenuDialog = function closeSelectMenuDialog() {
            var mainPage = $("div[data-role=page]:first-of-type");

            //Portal.router.navigate(Backbone.history.fragment, {trigger: false, replace: true});
            $.mobile.changePage( mainPage );
        };

        return _selectMenu;
    }());
});
